<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContentType extends Model 
{

    protected $table = 'lim_content_types';
    public $timestamps = true;
    protected $fillable = array('use_type_page', 'type_template', 'use_breadcrumb_prefix', 'content_template', 'pagination', 'use_category', 'use_branch', 'use_content', 'cache_time');
    protected $visible = array('use_type_page', 'type_template', 'use_breadcrumb_prefix', 'content_template', 'pagination', 'use_category', 'use_branch', 'use_content', 'cache_time');

    public function language()
    {
        return $this->hasOne('App\Models\ContentTypeLanguage', 'lim_content_type_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function contents()
    {
        return $this->hasMany('App\Models\Content', 'lim_content_type_id');
    }

    public function languages()
    {
        return $this->hasMany('App\Models\ContentTypeLanguage', 'lim_content_type_id');
    }

}